<?php
global $theme_sidebars;
$places = array();
foreach ($theme_sidebars as $sidebar){
    if ($sidebar['group'] !== 'footer')
        continue;
    $widgets = theme_get_dynamic_sidebar_data($sidebar['id']);
    if (!is_array($widgets) || count($widgets) < 1)
        continue;
    $places[$sidebar['id']] = $widgets;
}
$place_count = count($places);
$needLayout = ($place_count > 1);
if (theme_get_option('theme_override_default_footer_content')) {
    if ($place_count > 0) {
        $centred_begin = '<div class="art-center-wrapper"><div class="art-center-inner">';
        $centred_end = '</div></div><div class="clearfix"> </div>';
        if ($needLayout) { ?>
<div class="art-content-layout">
    <div class="art-content-layout-row">
        <?php 
        }
        foreach ($places as $widgets) { 
            if ($needLayout) { ?>
            <div class="art-layout-cell art-layout-cell-size<?php echo $place_count; ?>">
            <?php 
            }
            $centred = false;
            foreach ($widgets as $widget) {
                 $is_simple = ('simple' == $widget['style']);
                 if ($is_simple) {
                     $widget['class'] = implode(' ', array_merge(explode(' ', theme_get_array_value($widget, 'class', '')), array('art-footer-text')));
                 }
                 if (false === $centred && $is_simple) {
                     $centred = true;
                     echo $centred_begin;
                 }
                 if (true === $centred && !$is_simple) {
                     $centred = false;
                     echo $centred_end;
                 }
                 theme_print_widget($widget);
            } 
            if (true === $centred) {
                echo $centred_end;
            }
            if ($needLayout) {
           ?>
            </div>
        <?php 
            }
        } 
        if ($needLayout) { ?>
    </div>
</div>
        <?php 
        }
    }
?>
<div class="art-footer-text">
<?php
global $theme_default_options;
echo do_shortcode(theme_get_option('theme_override_default_footer_content') ? theme_get_option('theme_footer_content') : theme_get_array_value($theme_default_options, 'theme_footer_content'));
} else { 
?>
<div class="art-footer-text">
<?php theme_ob_start() ?>
  
<div class="art-content-layout">
    <div class="art-content-layout-row">
    <div class="art-layout-cell layout-item-0" style="width: 33%"><?php if (false === theme_print_sidebar('footer-1-widget-area')) { ?>
        <p style="text-align: left;"><span style="font-family: 'Titillium Web', Arial, 'Arial Unicode MS', Helvetica, sans-serif; font-size: 14px;"></span><span style="color: rgb(0, 0, 0); font-family: 'Open Sans', Arial, sans-serif; font-size: 14px;"><br /></span></p>
    <?php } ?></div><div class="art-layout-cell layout-item-0" style="width: 34%"><?php if (false === theme_print_sidebar('footer-2-widget-area')) { ?>
        <p><span style="font-family: 'Titillium Web', Arial, 'Arial Unicode MS', Helvetica, sans-serif; font-size: 14px;"><br /><br /><br /><small></small></span><br /></p>
    <?php } ?></div><div class="art-layout-cell layout-item-0" style="width: 33%"><?php if (false === theme_print_sidebar('footer-3-widget-area')) { ?>
        <p style="text-align:right;"><span style="font-family: 'Titillium Web', Arial, 'Arial Unicode MS', Helvetica, sans-serif; font-size: 14px;"><br /><br /><br />&copy; <small>Studio AK.<br />Sivuston toteutus Valonnopea Oy.</small></span><br /></p>
    <?php } ?></div>
    </div>
</div>

  
<?php echo do_shortcode(theme_ob_get_clean()) ?>
<?php } ?>

</div>
